# Painel Administrativo - Aviator

## 🎮 Acesso

- **URL:** `/painel`
- **Email:** gabaeditoroficial@gmail.com
- **Senha:** Kakekikoku18@

## 📊 Funcionalidades

### 1. Usuários
- Lista completa de usuários cadastrados
- Visualização de nome, telefone e saldo
- Estatísticas: total de usuários e saldo total no sistema

### 2. Movimentações
- Histórico completo de depósitos
- Status das transações (completo/pendente)
- Total depositado e número de transações

### 3. Histórico
- Registro de todas as jogadas realizadas
- Informações: usuário, aposta, multiplicador e ganho/perda
- Multiplicador médio e total de jogadas

### 4. Manipulação
**Controle de probabilidades do jogo real**

Configure as chances de cada faixa de multiplicador:
- **0x - 1.5x:** Crash rápido (padrão: 30%)
- **1.5x - 3x:** Baixo retorno (padrão: 40%)
- **3x - 6x:** Médio retorno (padrão: 20%)
- **6x - 15x:** Alto retorno (padrão: 10%)

⚠️ **Importante:** A soma de todas as probabilidades deve ser exatamente 100%

## 🎯 Como Funciona a Manipulação

1. Ajuste os sliders de cada faixa de multiplicador
2. O sistema valida automaticamente se a soma é 100%
3. Clique em "Salvar Configurações"
4. As novas probabilidades serão aplicadas imediatamente no jogo real

### Exemplo de Uso

**Para aumentar a dificuldade (mais crashes):**
- 0x - 1.5x: 50%
- 1.5x - 3x: 35%
- 3x - 6x: 12%
- 6x - 15x: 3%

**Para aumentar ganhos (mais multiplicadores altos):**
- 0x - 1.5x: 20%
- 1.5x - 3x: 30%
- 3x - 6x: 30%
- 6x - 15x: 20%

## 🔧 Arquivos

### Frontend
- `painel/index.html` - Interface do painel
- `painel/style.css` - Estilos
- `painel/script.js` - Lógica do painel

### Backend
- `backend/admin_get_users.php` - Lista usuários
- `backend/admin_get_deposits.php` - Lista depósitos
- `backend/admin_get_games.php` - Lista histórico de jogadas
- `backend/admin_get_probabilities.php` - Busca probabilidades salvas
- `backend/admin_save_probabilities.php` - Salva novas probabilidades
- `backend/get_probabilities.php` - API para o jogo buscar probabilidades

### Banco de Dados
Tabela criada automaticamente: `game_probabilities`
- `range_0_1_5` - Probabilidade 0x-1.5x
- `range_1_5_3` - Probabilidade 1.5x-3x
- `range_3_6` - Probabilidade 3x-6x
- `range_6_15` - Probabilidade 6x-15x

## 🎲 Integração com o Jogo

O jogo real (`/jogo`) carrega automaticamente as probabilidades do painel:

1. Ao carregar a página, busca as probabilidades em `get_probabilities.php`
2. Usa a função `generateMultiplier()` para gerar multiplicadores baseados nas probabilidades
3. Cada aposta usa as configurações mais recentes do painel

**OBS:** A página de teste (`/teste`) continua com multiplicadores fixos de 3x-10x.
