<?php
require_once __DIR__ . '/config.php';

header('Content-Type: application/json; charset=utf-8');

try {
    $data = json_decode(file_get_contents('php://input'), true);
    
    if (!isset($data['session_token']) || !isset($data['balance'])) {
        throw new Exception('Dados incompletos');
    }
    
    $sessionToken = trim($data['session_token']);
    $newBalance = floatval($data['balance']);
    
    if (empty($sessionToken)) {
        throw new Exception('Token de sessão vazio');
    }
    
    if ($newBalance < 0) {
        throw new Exception('Saldo inválido');
    }
    
    $db = Database::getInstance()->getConnection();
    
    // Verificar sessão
    $stmt = $db->prepare("SELECT user_id FROM sessions WHERE session_token = ? AND expires_at > NOW()");
    $stmt->execute([$sessionToken]);
    $session = $stmt->fetch();
    
    if (!$session) {
        throw new Exception('Sessão inválida ou expirada');
    }
    
    $userId = $session['user_id'];
    
    // Atualizar saldo
    $stmt = $db->prepare("UPDATE users SET balance = ? WHERE id = ?");
    $stmt->execute([$newBalance, $userId]);
    
    echo json_encode([
        'success' => true,
        'balance' => $newBalance
    ]);
    
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Erro no banco de dados: ' . $e->getMessage()
    ]);
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
