<?php
// Teste com CPF/CNPJ REAIS e validação
header('Content-Type: text/html; charset=utf-8');

$publicKey = 'd63c3a88-6d8e-4db3-8336-bfca624395f5';
$secretKey = 'fdec94fd-36e7-4a43-b0e1-cc18b3b7a9be';
$authToken = base64_encode($publicKey . ':' . $secretKey);

echo '<h1>🔍 Teste com Dados REAIS - Debug Completo</h1>';

// CPF REAL e válido (gerado validamente)
function validarCPF($cpf) {
    $cpf = preg_replace('/[^0-9]/', '', $cpf);
    if (strlen($cpf) != 11) return false;
    
    for ($t = 9; $t < 11; $t++) {
        for ($d = 0, $c = 0; $c < $t; $c++) {
            $d += $cpf[$c] * (($t + 1) - $c);
        }
        $d = ((10 * $d) % 11) % 10;
        if ($cpf[$c] != $d) return false;
    }
    return true;
}

// Gerar CPF válido
function gerarCPF() {
    $n1 = rand(0, 9);
    $n2 = rand(0, 9);
    $n3 = rand(0, 9);
    $n4 = rand(0, 9);
    $n5 = rand(0, 9);
    $n6 = rand(0, 9);
    $n7 = rand(0, 9);
    $n8 = rand(0, 9);
    $n9 = rand(0, 9);
    
    $d1 = $n9 * 2 + $n8 * 3 + $n7 * 4 + $n6 * 5 + $n5 * 6 + $n4 * 7 + $n3 * 8 + $n2 * 9 + $n1 * 10;
    $d1 = 11 - ($d1 % 11);
    if ($d1 >= 10) $d1 = 0;
    
    $d2 = $d1 * 2 + $n9 * 3 + $n8 * 4 + $n7 * 5 + $n6 * 6 + $n5 * 7 + $n4 * 8 + $n3 * 9 + $n2 * 10 + $n1 * 11;
    $d2 = 11 - ($d2 % 11);
    if ($d2 >= 10) $d2 = 0;
    
    return "$n1$n2$n3$n4$n5$n6$n7$n8$n9$d1$d2";
}

$cpfValido = '52998224725'; // CPF real válido

echo '<p><strong>CPF Usado:</strong> ' . $cpfValido . ' - <span style="color:' . (validarCPF($cpfValido) ? 'green">✅ VÁLIDO' : 'red">❌ INVÁLIDO') . '</span></p>';

$tests = [
    'Teste 1: Valor R$ 1,00 (100 centavos) - MÍNIMO' => [
        'cus_name' => 'Maria Silva Santos',
        'cus_email' => 'maria.silva@gmail.com',
        'cus_phone' => '11987654321',
        'cus_doc' => $cpfValido,
        'payType' => 'PIX',
        'transAmt' => 100,
        'product' => [
            'pro_name' => 'Créditos Aviator - Teste Mínimo',
            'pro_text' => 'Pacote de créditos para o jogo Aviator',
            'pro_category' => 'Entretenimento',
            'pro_email' => 'suporte@prattix.com',
            'pro_phone' => '11987654321',
            'pro_days_warranty' => 0,
            'pro_delivery_type' => 'Digital',
            'pro_text_email' => 'Seus créditos foram adicionados com sucesso',
            'pro_site' => 'https://prattix.com'
        ],
        'address_cep' => '01310100',
        'address_street' => 'Avenida Paulista',
        'address_number' => '1000',
        'address_district' => 'Bela Vista',
        'address_city' => 'São Paulo',
        'address_state' => 'SP',
        'address_country' => 'Brasil',
        'address_complement' => 'Conjunto 1',
        'trans_webhook_url' => 'https://prattix.com/backend/webhook.php'
    ],
    
    'Teste 2: Valor R$ 10,00 (1000 centavos)' => [
        'cus_name' => 'Maria Silva Santos',
        'cus_email' => 'maria.silva@gmail.com',
        'cus_phone' => '11987654321',
        'cus_doc' => $cpfValido,
        'payType' => 'PIX',
        'transAmt' => 1000,
        'product' => [
            'pro_name' => 'Créditos Aviator',
            'pro_text' => 'Pacote de créditos para o jogo Aviator',
            'pro_category' => 'Entretenimento',
            'pro_email' => 'suporte@prattix.com',
            'pro_phone' => '11987654321',
            'pro_days_warranty' => 0,
            'pro_delivery_type' => 'Digital',
            'pro_text_email' => 'Seus créditos foram adicionados com sucesso',
            'pro_site' => 'https://prattix.com'
        ],
        'address_cep' => '01310100',
        'address_street' => 'Avenida Paulista',
        'address_number' => '1000',
        'address_district' => 'Bela Vista',
        'address_city' => 'São Paulo',
        'address_state' => 'SP',
        'address_country' => 'Brasil',
        'address_complement' => 'Conjunto 1',
        'trans_webhook_url' => 'https://prattix.com/backend/webhook.php'
    ],
    
    'Teste 3: Valor R$ 50,00 (5000 centavos)' => [
        'cus_name' => 'Maria Silva Santos',
        'cus_email' => 'maria.silva@gmail.com',
        'cus_phone' => '11987654321',
        'cus_doc' => $cpfValido,
        'payType' => 'PIX',
        'transAmt' => 5000,
        'product' => [
            'pro_name' => 'Créditos Aviator - Pacote Médio',
            'pro_text' => 'Pacote de créditos para o jogo Aviator',
            'pro_category' => 'Entretenimento',
            'pro_email' => 'suporte@prattix.com',
            'pro_phone' => '11987654321',
            'pro_days_warranty' => 0,
            'pro_delivery_type' => 'Digital',
            'pro_text_email' => 'Seus créditos foram adicionados com sucesso',
            'pro_site' => 'https://prattix.com'
        ],
        'address_cep' => '01310100',
        'address_street' => 'Avenida Paulista',
        'address_number' => '1000',
        'address_district' => 'Bela Vista',
        'address_city' => 'São Paulo',
        'address_state' => 'SP',
        'address_country' => 'Brasil',
        'address_complement' => 'Conjunto 1',
        'trans_webhook_url' => 'https://prattix.com/backend/webhook.php'
    ],
    
    'Teste 4: Sem webhook_url' => [
        'cus_name' => 'Maria Silva Santos',
        'cus_email' => 'maria.silva@gmail.com',
        'cus_phone' => '11987654321',
        'cus_doc' => $cpfValido,
        'payType' => 'PIX',
        'transAmt' => 1000,
        'product' => [
            'pro_name' => 'Créditos Aviator',
            'pro_text' => 'Pacote de créditos para o jogo Aviator',
            'pro_category' => 'Entretenimento',
            'pro_email' => 'suporte@prattix.com',
            'pro_phone' => '11987654321',
            'pro_days_warranty' => 0,
            'pro_delivery_type' => 'Digital',
            'pro_text_email' => 'Seus créditos foram adicionados com sucesso',
            'pro_site' => 'https://prattix.com'
        ],
        'address_cep' => '01310100',
        'address_street' => 'Avenida Paulista',
        'address_number' => '1000',
        'address_district' => 'Bela Vista',
        'address_city' => 'São Paulo',
        'address_state' => 'SP',
        'address_country' => 'Brasil'
    ]
];

foreach ($tests as $testName => $payload) {
    echo '<div style="border:2px solid #333;padding:20px;margin:20px 0;border-radius:10px;background:#f9f9f9;">';
    echo '<h2 style="margin-top:0;color:#333;">' . $testName . '</h2>';
    
    echo '<details><summary style="cursor:pointer;font-weight:bold;">📄 Ver Payload Completo</summary>';
    echo '<pre style="background:#fff;padding:15px;border:1px solid #ddd;border-radius:5px;overflow:auto;">';
    echo json_encode($payload, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    echo '</pre></details>';
    
    // Capturar HEADERS de resposta também
    $responseHeaders = [];
    
    $ch = curl_init('https://api.paymaker.com.br/api/transactions');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Authorization: ' . $authToken
    ]);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_VERBOSE, true);
    curl_setopt($ch, CURLOPT_HEADER, true);
    
    $fullResponse = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $headerSize = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
    $headers = substr($fullResponse, 0, $headerSize);
    $body = substr($fullResponse, $headerSize);
    curl_close($ch);
    
    // Código em cores
    if ($httpCode == 200 || $httpCode == 201) {
        $color = 'green';
        $emoji = '✅ SUCESSO!';
        $bgColor = '#d4edda';
    } elseif ($httpCode == 400) {
        $color = 'orange';
        $emoji = '⚠️ BAD REQUEST';
        $bgColor = '#fff3cd';
    } elseif ($httpCode == 500) {
        $color = 'red';
        $emoji = '❌ ERRO SERVIDOR';
        $bgColor = '#f8d7da';
    } else {
        $color = 'gray';
        $emoji = '🤔 INDEFINIDO';
        $bgColor = '#e2e3e5';
    }
    
    echo '<div style="background:' . $bgColor . ';padding:15px;border-radius:8px;margin:15px 0;">';
    echo '<p style="font-size:20px;margin:0;"><strong>HTTP Code: <span style="color:' . $color . ';">' . $httpCode . '</span></strong> ' . $emoji . '</p>';
    echo '</div>';
    
    echo '<details><summary style="cursor:pointer;font-weight:bold;">📡 Headers de Resposta</summary>';
    echo '<pre style="background:#2d2d2d;color:#f8f8f2;padding:15px;border-radius:5px;overflow:auto;">';
    echo htmlspecialchars($headers);
    echo '</pre></details>';
    
    echo '<details open><summary style="cursor:pointer;font-weight:bold;">📥 Body da Resposta</summary>';
    echo '<pre style="background:#fff;padding:15px;border:1px solid #ddd;border-radius:5px;max-height:400px;overflow:auto;">';
    $jsonResponse = json_decode($body, true);
    if ($jsonResponse) {
        echo json_encode($jsonResponse, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    } else {
        echo htmlspecialchars($body);
    }
    echo '</pre></details>';
    
    // Se deu sucesso, destacar
    if ($httpCode == 200 || $httpCode == 201) {
        echo '<div style="background:#155724;color:white;padding:20px;border-radius:8px;margin-top:15px;">';
        echo '<h3 style="margin-top:0;">🎉 TRANSAÇÃO CRIADA COM SUCESSO!</h3>';
        echo '<p>A API funcionou! Este é o formato correto.</p>';
        echo '</div>';
        echo '</div>';
        break;
    }
    
    echo '</div>';
}

echo '<div style="margin-top:40px;padding:20px;background:#fff3cd;border:2px solid #ffc107;border-radius:10px;">';
echo '<h3>💡 Análise do Erro 500:</h3>';
echo '<ul>';
echo '<li><strong>Se TODOS derem 500:</strong> Problema na configuração da conta Paymaker (provider PIX não ativo)</li>';
echo '<li><strong>Se algum der 200/201:</strong> Descobrimos qual formato funciona!</li>';
echo '<li><strong>Se der 401:</strong> Credenciais inválidas</li>';
echo '<li><strong>Se der 400 com nova mensagem:</strong> Falta algum campo específico</li>';
echo '</ul>';
echo '<p><strong>Próximo passo:</strong> Se todos derem 500, contate o suporte Paymaker e mostre estes testes. O problema está na configuração da CONTA, não no código.</p>';
echo '</div>';

echo '<p style="color:#666;margin-top:30px;"><em>Teste concluído em ' . date('Y-m-d H:i:s') . '</em></p>';
?>
