<?php
// Teste PROGRESSIVO - Adicionar campos até funcionar
header('Content-Type: text/html; charset=utf-8');

$publicKey = 'd63c3a88-6d8e-4db3-8336-bfca624395f5';
$secretKey = 'fdec94fd-36e7-4a43-b0e1-cc18b3b7a9be';
$authToken = base64_encode($publicKey . ':' . $secretKey);

echo '<h1>🔬 Teste Progressivo - Descobrindo Campos Obrigatórios</h1>';

$tests = [
    'Teste 1: Product vazio' => [
        'cus_name' => 'João Silva',
        'cus_email' => 'teste@teste.com',
        'cus_phone' => '11987654321',
        'cus_doc' => '12345678909',
        'payType' => 'PIX',
        'transAmt' => 1000,
        'product' => []
    ],
    
    'Teste 2: Só pro_name' => [
        'cus_name' => 'João Silva',
        'cus_email' => 'teste@teste.com',
        'cus_phone' => '11987654321',
        'cus_doc' => '12345678909',
        'payType' => 'PIX',
        'transAmt' => 1000,
        'product' => [
            'pro_name' => 'Produto Teste'
        ]
    ],
    
    'Teste 3: pro_name + pro_text' => [
        'cus_name' => 'João Silva',
        'cus_email' => 'teste@teste.com',
        'cus_phone' => '11987654321',
        'cus_doc' => '12345678909',
        'payType' => 'PIX',
        'transAmt' => 1000,
        'product' => [
            'pro_name' => 'Produto Teste',
            'pro_text' => 'Descrição do produto'
        ]
    ],
    
    'Teste 4: Campos básicos do product' => [
        'cus_name' => 'João Silva',
        'cus_email' => 'teste@teste.com',
        'cus_phone' => '11987654321',
        'cus_doc' => '12345678909',
        'payType' => 'PIX',
        'transAmt' => 1000,
        'product' => [
            'pro_name' => 'Produto Teste',
            'pro_text' => 'Descrição',
            'pro_category' => 'Outros',
            'pro_email' => 'teste@teste.com',
            'pro_phone' => '11987654321'
        ]
    ],
    
    'Teste 5: Product COMPLETO' => [
        'cus_name' => 'João Silva',
        'cus_email' => 'teste@teste.com',
        'cus_phone' => '11987654321',
        'cus_doc' => '12345678909',
        'payType' => 'PIX',
        'transAmt' => 1000,
        'product' => [
            'pro_name' => 'Produto Teste',
            'pro_text' => 'Descrição completa',
            'pro_category' => 'Outros',
            'pro_email' => 'teste@teste.com',
            'pro_phone' => '11987654321',
            'pro_days_warranty' => 7,
            'pro_delivery_type' => 'Digital',
            'pro_text_email' => 'Email de confirmação',
            'pro_site' => 'https://prattix.com'
        ]
    ],
    
    'Teste 6: COMPLETO + Endereço' => [
        'cus_name' => 'João Silva',
        'cus_email' => 'teste@teste.com',
        'cus_phone' => '11987654321',
        'cus_doc' => '12345678909',
        'payType' => 'PIX',
        'transAmt' => 1000,
        'product' => [
            'pro_name' => 'Produto Teste',
            'pro_text' => 'Descrição completa',
            'pro_category' => 'Outros',
            'pro_email' => 'teste@teste.com',
            'pro_phone' => '11987654321',
            'pro_days_warranty' => 7,
            'pro_delivery_type' => 'Digital',
            'pro_text_email' => 'Email de confirmação',
            'pro_site' => 'https://prattix.com'
        ],
        'address_cep' => '01310100',
        'address_street' => 'Avenida Paulista',
        'address_number' => '1000',
        'address_district' => 'Bela Vista',
        'address_city' => 'São Paulo',
        'address_state' => 'SP',
        'address_country' => 'Brasil'
    ]
];

foreach ($tests as $testName => $payload) {
    echo '<div style="border:2px solid #ddd;padding:15px;margin:20px 0;border-radius:8px;">';
    echo '<h2 style="margin-top:0;">' . $testName . '</h2>';
    
    echo '<details><summary>📄 Ver Payload</summary>';
    echo '<pre style="background:#f5f5f5;padding:10px;border-radius:5px;">';
    echo json_encode($payload, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    echo '</pre></details>';
    
    $ch = curl_init('https://api.paymaker.com.br/api/transactions');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Authorization: ' . $authToken
    ]);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    // Código em cores
    if ($httpCode == 200 || $httpCode == 201) {
        $color = 'green';
        $emoji = '✅ SUCESSO!';
    } elseif ($httpCode == 400) {
        $color = 'orange';
        $emoji = '⚠️ FALTA CAMPO';
    } elseif ($httpCode == 500) {
        $color = 'red';
        $emoji = '❌ ERRO SERVIDOR';
    } else {
        $color = 'gray';
        $emoji = '🤔 INDEFINIDO';
    }
    
    echo '<p style="font-size:18px;"><strong>HTTP Code: <span style="color:' . $color . ';">' . $httpCode . '</span></strong> ' . $emoji . '</p>';
    
    echo '<details open><summary>📥 Resposta da API</summary>';
    echo '<pre style="background:#fff;padding:10px;border:1px solid #ddd;border-radius:5px;max-height:300px;overflow:auto;">';
    $jsonResponse = json_decode($response, true);
    if ($jsonResponse) {
        echo json_encode($jsonResponse, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    } else {
        echo htmlspecialchars($response);
    }
    echo '</pre></details>';
    
    // Se deu sucesso, parar aqui
    if ($httpCode == 200 || $httpCode == 201) {
        echo '<div style="background:#d4edda;border:1px solid #c3e6cb;padding:15px;border-radius:5px;margin-top:10px;">';
        echo '<h3 style="color:#155724;margin-top:0;">🎉 FUNCIONOU!</h3>';
        echo '<p>Este é o formato mínimo que a API aceita. Use este como base!</p>';
        echo '</div>';
        echo '</div>';
        break;
    }
    
    echo '</div>';
}

echo '<p style="color:#666;margin-top:30px;"><em>Teste concluído em ' . date('Y-m-d H:i:s') . '</em></p>';
?>
