<?php
// Teste ISOLADO da API Paymaker
// Acesse: https://prattix.com/backend/test_isolated.php

require_once 'config.php';

header('Content-Type: text/html; charset=utf-8');

$publicKey = 'd63c3a88-6d8e-4db3-8336-bfca624395f5';
$secretKey = 'fdec94fd-36e7-4a43-b0e1-cc18b3b7a9be';
$authToken = base64_encode($publicKey . ':' . $secretKey);

// Dados COMPLETOS para teste
$testData = [
    'cus_name' => 'Cliente Aviator',
    'cus_email' => 'clienteaviator@gmail.com',
    'cus_phone' => '11999999999',
    'cus_doc' => '12345678909', // CPF válido
    'payType' => 'PIX',
    'transAmt' => 1000, // R$ 10,00
    'product' => [
        'pro_name' => 'Teste Aviator',
        'pro_text' => 'Teste de integração',
        'pro_category' => 'Jogos',
        'pro_email' => 'suporte@aviator.com',
        'pro_phone' => '11999999999',
        'pro_days_warranty' => 7,
        'pro_delivery_type' => 'Digital',
        'pro_text_email' => 'Teste',
        'pro_site' => 'https://prattix.com'
    ],
    'address_cep' => '01310100',
    'address_street' => 'Avenida Paulista',
    'address_number' => '1000',
    'address_district' => 'Bela Vista',
    'address_city' => 'São Paulo',
    'address_state' => 'SP',
    'address_country' => 'Brasil',
    'address_complement' => '',
    'trans_webhook_url' => 'https://prattix.com/backend/webhook.php'
];

echo '<h1>🧪 Teste Isolado API Paymaker</h1>';
echo '<h2>📤 Dados Enviados:</h2>';
echo '<pre style="background:#f5f5f5;padding:15px;border-radius:5px;">';
echo json_encode($testData, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
echo '</pre>';

echo '<h2>🔑 Authorization Token:</h2>';
echo '<pre style="background:#f5f5f5;padding:15px;border-radius:5px;">';
echo $authToken;
echo '</pre>';

// Fazer requisição
$ch = curl_init('https://api.paymaker.com.br/api/transactions');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($testData));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
    'Authorization: ' . $authToken
]);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$curlError = curl_error($ch);
curl_close($ch);

echo '<h2>📥 Resposta da API:</h2>';
echo '<p><strong>HTTP Code:</strong> <span style="color:' . ($httpCode == 200 || $httpCode == 201 ? 'green' : 'red') . ';font-weight:bold;">' . $httpCode . '</span></p>';

if ($curlError) {
    echo '<p style="color:red;"><strong>cURL Error:</strong> ' . htmlspecialchars($curlError) . '</p>';
}

echo '<pre style="background:#f5f5f5;padding:15px;border-radius:5px;max-height:500px;overflow:auto;">';
$jsonResponse = json_decode($response, true);
if ($jsonResponse) {
    echo json_encode($jsonResponse, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
} else {
    echo htmlspecialchars($response);
}
echo '</pre>';

// Tentar outras variações
echo '<hr>';
echo '<h2>🔬 Testando Variações de Campos:</h2>';

$variations = [
    'Teste 1: CPF com pontos e traço' => [
        'cus_name' => 'Cliente Aviator',
        'cus_email' => 'clienteaviator@gmail.com',
        'cus_phone' => '11999999999',
        'cus_doc' => '123.456.789-09',
        'payType' => 'PIX',
        'transAmt' => 1000,
        'product' => [
            'pro_name' => 'Teste',
            'pro_text' => 'Teste',
            'pro_category' => 'Jogos',
            'pro_email' => 'suporte@aviator.com',
            'pro_phone' => '11999999999',
            'pro_days_warranty' => 7,
            'pro_delivery_type' => 'Digital',
            'pro_text_email' => 'Teste',
            'pro_site' => 'https://prattix.com'
        ],
        'address_cep' => '01310100',
        'address_street' => 'Avenida Paulista',
        'address_number' => '1000',
        'address_district' => 'Bela Vista',
        'address_city' => 'São Paulo',
        'address_state' => 'SP',
        'address_country' => 'Brasil'
    ],
    'Teste 2: Telefone formatado (11) 99999-9999' => [
        'cus_name' => 'Cliente Aviator',
        'cus_email' => 'clienteaviator@gmail.com',
        'cus_phone' => '(11) 99999-9999',
        'cus_doc' => '12345678909',
        'payType' => 'PIX',
        'transAmt' => 1000,
        'product' => [
            'pro_name' => 'Teste',
            'pro_text' => 'Teste',
            'pro_category' => 'Jogos',
            'pro_email' => 'suporte@aviator.com',
            'pro_phone' => '(11) 99999-9999',
            'pro_days_warranty' => 7,
            'pro_delivery_type' => 'Digital',
            'pro_text_email' => 'Teste',
            'pro_site' => 'https://prattix.com'
        ],
        'address_cep' => '01310-100',
        'address_street' => 'Avenida Paulista',
        'address_number' => '1000',
        'address_district' => 'Bela Vista',
        'address_city' => 'São Paulo',
        'address_state' => 'SP',
        'address_country' => 'Brasil'
    ],
    'Teste 3: Sem endereço' => [
        'cus_name' => 'Cliente Aviator',
        'cus_email' => 'clienteaviator@gmail.com',
        'cus_phone' => '11999999999',
        'cus_doc' => '12345678909',
        'payType' => 'PIX',
        'transAmt' => 1000,
        'product' => [
            'pro_name' => 'Teste',
            'pro_text' => 'Teste',
            'pro_category' => 'Jogos',
            'pro_email' => 'suporte@aviator.com',
            'pro_phone' => '11999999999',
            'pro_days_warranty' => 7,
            'pro_delivery_type' => 'Digital',
            'pro_text_email' => 'Teste',
            'pro_site' => 'https://prattix.com'
        ]
    ]
];

foreach ($variations as $testName => $testPayload) {
    echo '<h3>' . $testName . '</h3>';
    echo '<pre style="background:#f0f0f0;padding:10px;border-left:3px solid #666;">';
    echo json_encode($testPayload, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    echo '</pre>';
    
    $ch = curl_init('https://api.paymaker.com.br/api/transactions');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($testPayload));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Authorization: ' . $authToken
    ]);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    
    $resp = curl_exec($ch);
    $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    $color = ($code == 200 || $code == 201) ? 'green' : 'red';
    echo '<p><strong>HTTP Code:</strong> <span style="color:' . $color . ';">' . $code . '</span></p>';
    echo '<pre style="background:#fff;padding:10px;border:1px solid #ddd;max-height:300px;overflow:auto;">';
    $jsonResp = json_decode($resp, true);
    if ($jsonResp) {
        echo json_encode($jsonResp, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    } else {
        echo htmlspecialchars($resp);
    }
    echo '</pre>';
    echo '<hr style="border:1px dashed #ccc;">';
}

echo '<p style="color:#666;margin-top:30px;"><em>Teste concluído em ' . date('Y-m-d H:i:s') . '</em></p>';
