<?php
// Teste de AUTENTICAÇÃO da API Paymaker
header('Content-Type: text/html; charset=utf-8');

$publicKey = 'd63c3a88-6d8e-4db3-8336-bfca624395f5';
$secretKey = 'fdec94fd-36e7-4a43-b0e1-cc18b3b7a9be';
$authToken = base64_encode($publicKey . ':' . $secretKey);

echo '<h1>🔐 Teste de Autenticação Paymaker</h1>';

// Teste 1: GET sem autenticação
echo '<h2>Teste 1: GET /api/transactions (sem auth)</h2>';
$ch = curl_init('https://api.paymaker.com.br/api/transactions');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
$resp = curl_exec($ch);
$code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);
echo '<p>HTTP Code: <strong style="color:' . ($code == 401 ? 'orange' : 'red') . ';">' . $code . '</strong> (esperado 401 Unauthorized)</p>';
echo '<pre>' . htmlspecialchars($resp) . '</pre><hr>';

// Teste 2: GET com autenticação
echo '<h2>Teste 2: GET /api/transactions (com auth)</h2>';
$ch = curl_init('https://api.paymaker.com.br/api/transactions');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
    'Authorization: ' . $authToken
]);
$resp = curl_exec($ch);
$code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);
echo '<p>HTTP Code: <strong style="color:' . ($code == 200 ? 'green' : 'red') . ';">' . $code . '</strong></p>';
echo '<pre style="max-height:400px;overflow:auto;">' . htmlspecialchars($resp) . '</pre><hr>';

// Teste 3: Verificar se existe endpoint de configuração/conta
echo '<h2>Teste 3: GET /api/account ou /api/me</h2>';
foreach (['/api/account', '/api/me', '/api/user', '/api/config'] as $endpoint) {
    echo '<h3>' . $endpoint . '</h3>';
    $ch = curl_init('https://api.paymaker.com.br' . $endpoint);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Authorization: ' . $authToken
    ]);
    $resp = curl_exec($ch);
    $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    $color = ($code == 200) ? 'green' : (($code == 404) ? 'gray' : 'red');
    echo '<p>HTTP Code: <strong style="color:' . $color . ';">' . $code . '</strong></p>';
    if ($code != 404) {
        echo '<pre>' . htmlspecialchars($resp) . '</pre>';
    }
    echo '<hr style="border:1px dashed #ccc;">';
}

echo '<h2>💡 Diagnóstico:</h2>';
echo '<p><strong style="color:green;">✅ API está respondendo!</strong> (404 é normal para GET em endpoints de criação)</p>';

echo '<h2>🧪 Teste 4: POST Mínimo Absoluto</h2>';
$minimalPayload = [
    'cus_name' => 'João Silva',
    'cus_email' => 'teste@teste.com',
    'cus_phone' => '11987654321',
    'cus_doc' => '12345678909',
    'payType' => 'PIX',
    'transAmt' => 1000
];

echo '<pre>' . json_encode($minimalPayload, JSON_PRETTY_PRINT) . '</pre>';

$ch = curl_init('https://api.paymaker.com.br/api/transactions');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($minimalPayload));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
    'Authorization: ' . $authToken
]);
$resp = curl_exec($ch);
$code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

$color = ($code == 200 || $code == 201) ? 'green' : 'red';
echo '<p>HTTP Code: <strong style="color:' . $color . ';">' . $code . '</strong></p>';
echo '<pre style="max-height:400px;overflow:auto;background:#f5f5f5;padding:10px;">' . htmlspecialchars($resp) . '</pre>';

echo '<ul>';
echo '<li>Se todos deram 401: <strong style="color:red;">Credenciais inválidas</strong></li>';
echo '<li>Se GET /api/transactions deu 200: <strong style="color:green;">Auth OK</strong> - problema é no payload</li>';
echo '<li>Se deu 500 em tudo: <strong style="color:orange;">Conta não configurada</strong> ou em modo sandbox</li>';
echo '<li><strong>Se POST deu 400:</strong> Falta campo obrigatório (veja mensagem)</li>';
echo '<li><strong>Se POST deu 500:</strong> Provider PIX não configurado na conta Paymaker</li>';
echo '</ul>';
?>
