<?php
// Página de teste para API Paymaker - Testa 10 variações diferentes

$publicKey = 'd63c3a88-6d8e-4db3-8336-bfca624395f5';
$secretKey = 'fdec94fd-36e7-4a43-b0e1-cc18b3b7a9be';
$authToken = base64_encode($publicKey . ':' . $secretKey);

// Dados base
$baseData = [
    'nome' => 'Gabriel Alves',
    'email' => 'clienteaviator@gmail.com',
    'tel' => '75991385159',
    'documento' => '90580307093',
    'payType' => 'PIX',
    'transAmt' => 2000,
    'address_cep' => '00000000',
    'produto' => [
        'pro_name' => 'Crédito Aviator',
        'pro_text' => 'Depósito para jogo Aviator',
        'pro_categoria' => 'game',
        'pro_email' => 'clienteaviator@gmail.com',
        'pro_phone' => '75991385159',
        'pro_days_warranty' => 0,
        'pro_delivery_type' => 'digital',
        'pro_text_email' => 'Depósito Aviator',
        'pro_site' => 'https://prattix.com'
    ],
    'trans_webhook_url' => 'https://prattix.com/backend/webhook.php',
    'address_street' => 'Rua Aviator',
    'address_number' => '123',
    'address_district' => 'Centro',
    'address_city' => 'São Paulo',
    'address_state' => 'SP',
    'address_country' => 'Brasil',
    'address_complement' => ''
];

// 10 variações de URLs para testar
$urlVariations = [
    'https://api.paymaker.com.br/api/transacoes',
    'https://api.paymaker.com.br/api/transações',
    'https://api.paymaker.com.br/api/transa%C3%A7%C3%B5es',
    'https://api.paymaker.com.br/transacoes',
    'https://api.paymaker.com.br/transações',
    'https://paymaker.com.br/api/transacoes',
    'https://api.paymaker.com.br/v1/api/transacoes',
    'https://api.paymaker.com.br/transaction',
    'https://api.paymaker.com.br/api/transaction',
    'https://api.paymaker.com.br/api/transactions'
];

function testApiCall($url, $data, $authToken, $variation) {
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Authorization: ' . $authToken
    ]);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    curl_close($ch);
    
    return [
        'variation' => $variation,
        'url' => $url,
        'http_code' => $httpCode,
        'response' => $response,
        'error' => $error,
        'success' => ($httpCode == 200 || $httpCode == 201)
    ];
}

?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Teste API Paymaker - 10 Variações</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #1a1d29 0%, #0d0f16 100%);
            color: #fff;
            padding: 20px;
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
        }
        
        h1 {
            text-align: center;
            margin-bottom: 30px;
            color: #22c55e;
            text-shadow: 0 0 20px rgba(34, 197, 94, 0.5);
        }
        
        .test-card {
            background: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 12px;
            padding: 20px;
            margin-bottom: 20px;
            transition: all 0.3s;
        }
        
        .test-card:hover {
            transform: translateY(-2px);
            border-color: rgba(34, 197, 94, 0.3);
        }
        
        .test-card.success {
            border-color: #22c55e;
            background: rgba(34, 197, 94, 0.1);
        }
        
        .test-card.error {
            border-color: #ef4444;
            background: rgba(239, 68, 68, 0.05);
        }
        
        .test-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 15px;
        }
        
        .variation-number {
            font-size: 24px;
            font-weight: bold;
            color: #22c55e;
        }
        
        .status-badge {
            padding: 6px 16px;
            border-radius: 20px;
            font-size: 14px;
            font-weight: 600;
        }
        
        .status-badge.success {
            background: #22c55e;
            color: #000;
        }
        
        .status-badge.error {
            background: #ef4444;
            color: #fff;
        }
        
        .url-display {
            background: rgba(0, 0, 0, 0.3);
            padding: 10px;
            border-radius: 6px;
            font-family: 'Courier New', monospace;
            font-size: 13px;
            margin-bottom: 10px;
            word-break: break-all;
        }
        
        .http-code {
            display: inline-block;
            padding: 4px 10px;
            border-radius: 4px;
            font-weight: bold;
            margin-right: 10px;
        }
        
        .http-200, .http-201 {
            background: #22c55e;
            color: #000;
        }
        
        .http-404 {
            background: #f59e0b;
            color: #000;
        }
        
        .http-400, .http-401, .http-500 {
            background: #ef4444;
            color: #fff;
        }
        
        .response-box {
            background: rgba(0, 0, 0, 0.5);
            padding: 15px;
            border-radius: 6px;
            margin-top: 10px;
            max-height: 200px;
            overflow-y: auto;
        }
        
        .response-box pre {
            margin: 0;
            font-size: 12px;
            white-space: pre-wrap;
            word-wrap: break-word;
        }
        
        .auth-info {
            background: rgba(34, 197, 94, 0.1);
            border: 1px solid rgba(34, 197, 94, 0.3);
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 30px;
        }
        
        .auth-info h3 {
            margin-bottom: 10px;
            color: #22c55e;
        }
        
        .auth-info code {
            background: rgba(0, 0, 0, 0.3);
            padding: 2px 6px;
            border-radius: 4px;
            font-size: 12px;
        }
        
        .summary {
            position: fixed;
            top: 20px;
            right: 20px;
            background: rgba(34, 197, 94, 0.2);
            border: 2px solid #22c55e;
            border-radius: 12px;
            padding: 20px;
            min-width: 200px;
        }
        
        .summary h3 {
            margin-bottom: 10px;
            color: #22c55e;
        }
        
        .summary-stats {
            font-size: 14px;
        }
        
        .summary-stats div {
            margin: 5px 0;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>🧪 Teste API Paymaker - 10 Variações</h1>
        
        <div class="auth-info">
            <h3>📋 Informações de Autenticação</h3>
            <p><strong>Public Key:</strong> <code><?php echo $publicKey; ?></code></p>
            <p><strong>Secret Key:</strong> <code><?php echo substr($secretKey, 0, 10); ?>...</code></p>
            <p><strong>Auth Token (Base64):</strong> <code><?php echo substr($authToken, 0, 30); ?>...</code></p>
        </div>
        
        <?php
        $results = [];
        $successCount = 0;
        
        foreach ($urlVariations as $index => $url) {
            $result = testApiCall($url, $baseData, $authToken, $index + 1);
            $results[] = $result;
            if ($result['success']) $successCount++;
            
            $cardClass = $result['success'] ? 'success' : 'error';
            $statusClass = $result['success'] ? 'success' : 'error';
            $statusText = $result['success'] ? '✅ SUCESSO' : '❌ ERRO';
            
            $httpClass = 'http-' . $result['http_code'];
            
            echo "<div class='test-card {$cardClass}'>";
            echo "<div class='test-header'>";
            echo "<span class='variation-number'>Variação #{$result['variation']}</span>";
            echo "<span class='status-badge {$statusClass}'>{$statusText}</span>";
            echo "</div>";
            
            echo "<div class='url-display'>{$url}</div>";
            
            echo "<div>";
            echo "<span class='http-code {$httpClass}'>HTTP {$result['http_code']}</span>";
            if ($result['error']) {
                echo "<span style='color: #ef4444;'>cURL Error: {$result['error']}</span>";
            }
            echo "</div>";
            
            echo "<div class='response-box'>";
            echo "<pre>" . htmlspecialchars(json_encode(json_decode($result['response']), JSON_PRETTY_PRINT)) . "</pre>";
            echo "</div>";
            
            echo "</div>";
        }
        ?>
        
        <div class="summary">
            <h3>📊 Resumo</h3>
            <div class="summary-stats">
                <div><strong>Total:</strong> <?php echo count($results); ?></div>
                <div style="color: #22c55e;"><strong>Sucesso:</strong> <?php echo $successCount; ?></div>
                <div style="color: #ef4444;"><strong>Erro:</strong> <?php echo count($results) - $successCount; ?></div>
            </div>
        </div>
    </div>
</body>
</html>
