<?php
header('Content-Type: application/json');

require_once __DIR__ . '/config.php';

$tests = [];

// Teste 1: Conexão com o banco
try {
    $pdo->query("SELECT 1");
    $tests['conexao'] = '✓ OK';
} catch (PDOException $e) {
    $tests['conexao'] = '✗ ERRO: ' . $e->getMessage();
}

// Teste 2: Verificar se tabela admins existe
try {
    $stmt = $pdo->query("SHOW TABLES LIKE 'admins'");
    $exists = $stmt->fetch();
    $tests['tabela_admins'] = $exists ? '✓ Existe' : '✗ NÃO existe';
} catch (PDOException $e) {
    $tests['tabela_admins'] = '✗ ERRO: ' . $e->getMessage();
}

// Teste 3: Contar admins
try {
    $stmt = $pdo->query("SELECT COUNT(*) FROM admins");
    $count = $stmt->fetchColumn();
    $tests['total_admins'] = $count . ' admin(s)';
} catch (PDOException $e) {
    $tests['total_admins'] = '✗ ERRO: ' . $e->getMessage();
}

// Teste 4: Verificar se tabela game_probabilities existe
try {
    $stmt = $pdo->query("SHOW TABLES LIKE 'game_probabilities'");
    $exists = $stmt->fetch();
    $tests['tabela_probabilities'] = $exists ? '✓ Existe' : '✗ NÃO existe';
} catch (PDOException $e) {
    $tests['tabela_probabilities'] = '✗ ERRO: ' . $e->getMessage();
}

// Teste 5: Listar todos os admins
try {
    $stmt = $pdo->query("SELECT id, email, created_at FROM admins");
    $admins = $stmt->fetchAll(PDO::FETCH_ASSOC);
    $tests['lista_admins'] = $admins;
} catch (PDOException $e) {
    $tests['lista_admins'] = '✗ ERRO: ' . $e->getMessage();
}

echo json_encode($tests, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
