<?php
// Script de instalação do painel admin
require_once __DIR__ . '/config.php';

echo "🚀 Instalando Painel Administrativo...\n\n";

try {
    // Criar tabela de admins
    echo "📊 Criando tabela de administradores...\n";
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS admins (
            id INT PRIMARY KEY AUTO_INCREMENT,
            email VARCHAR(255) UNIQUE NOT NULL,
            password VARCHAR(255) NOT NULL,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        )
    ");
    echo "✓ Tabela 'admins' criada com sucesso!\n\n";
    
    // Hash da senha
    $password = 'Kakekikoku18@';
    $hashedPassword = password_hash($password, PASSWORD_BCRYPT);
    
    // Inserir admin padrão
    echo "👤 Criando usuário administrador...\n";
    $stmt = $pdo->prepare("
        INSERT INTO admins (email, password) 
        VALUES (?, ?)
        ON DUPLICATE KEY UPDATE password = ?
    ");
    $stmt->execute(['gabaeditoroficial@gmail.com', $hashedPassword, $hashedPassword]);
    echo "✓ Admin criado/atualizado com sucesso!\n\n";
    
    // Criar tabela de probabilidades
    echo "🎲 Criando tabela de probabilidades...\n";
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS game_probabilities (
            id INT PRIMARY KEY AUTO_INCREMENT,
            range_0_1_5 INT NOT NULL DEFAULT 30,
            range_1_5_3 INT NOT NULL DEFAULT 40,
            range_3_6 INT NOT NULL DEFAULT 20,
            range_6_15 INT NOT NULL DEFAULT 10,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
        )
    ");
    echo "✓ Tabela 'game_probabilities' criada com sucesso!\n\n";
    
    // Verificar se já existe configuração de probabilidade
    $stmt = $pdo->query("SELECT COUNT(*) FROM game_probabilities");
    $count = $stmt->fetchColumn();
    
    if ($count == 0) {
        echo "⚙️ Inserindo probabilidades padrão...\n";
        $pdo->exec("
            INSERT INTO game_probabilities (range_0_1_5, range_1_5_3, range_3_6, range_6_15) 
            VALUES (30, 40, 20, 10)
        ");
        echo "✓ Probabilidades padrão configuradas!\n\n";
    } else {
        echo "ℹ️ Probabilidades já configuradas!\n\n";
    }
    
    echo "✅ Instalação concluída com sucesso!\n\n";
    echo "════════════════════════════════════════\n";
    echo "📋 Credenciais do Painel Admin:\n";
    echo "════════════════════════════════════════\n";
    echo "🌐 URL: /painel\n";
    echo "📧 Email: gabaeditoroficial@gmail.com\n";
    echo "🔑 Senha: Kakekikoku18@\n";
    echo "════════════════════════════════════════\n\n";
    
} catch (PDOException $e) {
    echo "❌ Erro na instalação: " . $e->getMessage() . "\n";
    exit(1);
}
