<?php
require_once __DIR__ . '/config.php';

header('Content-Type: application/json; charset=utf-8');

try {
    $db = Database::getInstance()->getConnection();
    
    // Buscar últimos 10 multiplicadores do histórico de jogos
    $stmt = $db->prepare("
        SELECT multiplier 
        FROM game_history 
        ORDER BY created_at DESC 
        LIMIT 10
    ");
    $stmt->execute();
    $results = $stmt->fetchAll(PDO::FETCH_COLUMN);
    
    // Se não houver histórico, gerar valores aleatórios padrão
    if (empty($results)) {
        $defaults = [];
        for ($i = 0; $i < 5; $i++) {
            // Gerar multiplicadores aleatórios entre 1.0x e 15x
            $rand = mt_rand(10, 1500) / 100;
            $defaults[] = $rand;
        }
        $results = $defaults;
    }
    
    echo json_encode([
        'success' => true,
        'multipliers' => array_map('floatval', $results)
    ]);
    
} catch (PDOException $e) {
    http_response_code(500);
    error_log("Erro PDO get_recent_multipliers.php: " . $e->getMessage());
    
    echo json_encode([
        'success' => false,
        'message' => 'Erro ao buscar histórico',
        'multipliers' => []
    ]);
    
} catch (Exception $e) {
    http_response_code(400);
    
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage(),
        'multipliers' => []
    ]);
}
