<?php
require_once __DIR__ . '/config.php';

try {
    $stmt = $pdo->query("SELECT * FROM game_probabilities ORDER BY id DESC LIMIT 1");
    $probabilities = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$probabilities) {
        // Return default probabilities
        echo json_encode([
            'success' => true,
            'range_0_1_5' => 30,
            'range_1_5_3' => 40,
            'range_3_6' => 20,
            'range_6_15' => 10
        ]);
    } else {
        echo json_encode([
            'success' => true,
            'range_0_1_5' => intval($probabilities['range_0_1_5']),
            'range_1_5_3' => intval($probabilities['range_1_5_3']),
            'range_3_6' => intval($probabilities['range_3_6']),
            'range_6_15' => intval($probabilities['range_6_15'])
        ]);
    }
    
} catch (PDOException $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Erro ao buscar probabilidades'
    ]);
}
