<?php
require_once __DIR__ . '/config.php';

header('Content-Type: application/json; charset=utf-8');

try {
    $sessionToken = $_GET['session_token'] ?? '';
    
    if (empty($sessionToken)) {
        throw new Exception('Token não fornecido');
    }
    
    $db = Database::getInstance()->getConnection();
    
    // Verificar sessão e buscar saldo
    $stmt = $db->prepare("
        SELECT u.id, u.name, u.balance, u.total_deposited 
        FROM sessions s 
        JOIN users u ON s.user_id = u.id 
        WHERE s.session_token = ? AND s.expires_at > NOW()
    ");
    $stmt->execute([$sessionToken]);
    $result = $stmt->fetch();
    
    if (!$result) {
        throw new Exception('Sessão inválida ou expirada');
    }
    
    echo json_encode([
        'success' => true,
        'user_id' => (int)$result['id'],
        'name' => $result['name'],
        'balance' => (float)$result['balance'],
        'total_deposited' => (float)$result['total_deposited']
    ]);
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
