<?php
// Configurações do banco de dados
define('DB_HOST', 'localhost');
define('DB_NAME', 'wwprat_aviator');
define('DB_USER', 'wwprat_aviator');
define('DB_PASS', 'Kakekikoku18@');
define('DB_CHARSET', 'utf8mb4');

// Configurações da Paymaker (antiga SeedPay)
define('SEEDPAY_PUBLIC_KEY', 'd63c3a88-6d8e-4db3-8336-bfca624395f5');
define('SEEDPAY_SECRET_KEY', 'fdec94fd-36e7-4a43-b0e1-cc18b3b7a9be');
define('SEEDPAY_API_URL', 'https://api.paymaker.com.br/api/transactions');

// Configurações gerais
define('SITE_URL', 'https://prattix.com');
define('SESSION_DURATION', 86400 * 30); // 30 dias

// Timezone
date_default_timezone_set('America/Sao_Paulo');

// Conexão com o banco de dados
class Database {
    private static $instance = null;
    private $connection;
    
    private function __construct() {
        try {
            $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=" . DB_CHARSET;
            $options = [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES => false,
            ];
            $this->connection = new PDO($dsn, DB_USER, DB_PASS, $options);
        } catch (PDOException $e) {
            error_log("Database connection error: " . $e->getMessage());
            throw new Exception("Erro ao conectar ao banco de dados");
        }
    }
    
    public static function getInstance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    public function getConnection() {
        return $this->connection;
    }
}

// Criar instância global do PDO para facilitar uso
try {
    $pdo = Database::getInstance()->getConnection();
} catch (Exception $e) {
    error_log("Erro ao obter conexão: " . $e->getMessage());
    if (!headers_sent()) {
        http_response_code(500);
        echo json_encode(['success' => false, 'message' => 'Erro de conexão com banco de dados']);
    }
    exit;
}

// Headers para CORS
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');
header('Content-Type: application/json; charset=utf-8');

// Lidar com preflight requests
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}
