<?php
require_once __DIR__ . '/config.php';

try {
    $data = json_decode(file_get_contents('php://input'), true);
    
    $email = $data['email'] ?? '';
    $password = $data['password'] ?? '';
    
    if (empty($email) || empty($password)) {
        echo json_encode([
            'success' => false,
            'message' => 'Email e senha são obrigatórios'
        ]);
        exit;
    }
    
    // Buscar admin no banco
    $stmt = $pdo->prepare("SELECT * FROM admins WHERE email = ?");
    $stmt->execute([$email]);
    $admin = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$admin) {
        echo json_encode([
            'success' => false,
            'message' => 'Email ou senha incorretos'
        ]);
        exit;
    }
    
    // Verificar senha
    if (password_verify($password, $admin['password'])) {
        // Gerar token de sessão
        $sessionToken = bin2hex(random_bytes(32));
        
        echo json_encode([
            'success' => true,
            'session_token' => $sessionToken,
            'email' => $admin['email']
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'Email ou senha incorretos'
        ]);
    }
    
} catch (PDOException $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Erro no servidor: ' . $e->getMessage()
    ]);
}
