<?php
require_once __DIR__ . '/config.php';

try {
    $stmt = $pdo->query("
        SELECT 
            id, 
            name, 
            whatsapp, 
            balance, 
            created_at 
        FROM users 
        ORDER BY created_at DESC
    ");
    
    $users = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode([
        'success' => true,
        'users' => $users
    ]);
    
} catch (PDOException $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Erro ao buscar usuários: ' . $e->getMessage()
    ]);
}
