<?php
require_once __DIR__ . '/config.php';

try {
    // Create table if not exists
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS game_probabilities (
            id INT PRIMARY KEY AUTO_INCREMENT,
            range_0_1_5 INT NOT NULL DEFAULT 30,
            range_1_5_3 INT NOT NULL DEFAULT 40,
            range_3_6 INT NOT NULL DEFAULT 20,
            range_6_15 INT NOT NULL DEFAULT 10,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
        )
    ");
    
    $stmt = $pdo->query("SELECT * FROM game_probabilities ORDER BY id DESC LIMIT 1");
    $probabilities = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$probabilities) {
        // Insert default values
        $pdo->exec("
            INSERT INTO game_probabilities (range_0_1_5, range_1_5_3, range_3_6, range_6_15) 
            VALUES (30, 40, 20, 10)
        ");
        
        $stmt = $pdo->query("SELECT * FROM game_probabilities ORDER BY id DESC LIMIT 1");
        $probabilities = $stmt->fetch(PDO::FETCH_ASSOC);
    }
    
    echo json_encode([
        'success' => true,
        'probabilities' => $probabilities
    ]);
    
} catch (PDOException $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Erro ao buscar probabilidades: ' . $e->getMessage()
    ]);
}
