<?php
require_once __DIR__ . '/config.php';

try {
    $stmt = $pdo->query("
        SELECT 
            gh.id,
            gh.user_id,
            gh.bet_amount,
            gh.multiplier,
            gh.win_amount,
            gh.result,
            gh.created_at,
            u.name as user_name
        FROM game_history gh
        LEFT JOIN users u ON gh.user_id = u.id
        ORDER BY gh.created_at DESC
        LIMIT 100
    ");
    
    $games = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode([
        'success' => true,
        'games' => $games
    ]);
    
} catch (PDOException $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Erro ao buscar histórico: ' . $e->getMessage()
    ]);
}
