<?php
require_once __DIR__ . '/config.php';

try {
    $stmt = $pdo->query("
        SELECT 
            t.id,
            t.user_id,
            t.amount,
            t.status,
            t.created_at,
            u.name as user_name
        FROM transactions t
        LEFT JOIN users u ON t.user_id = u.id
        ORDER BY t.created_at DESC
    ");
    
    $deposits = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode([
        'success' => true,
        'deposits' => $deposits
    ]);
    
} catch (PDOException $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Erro ao buscar depósitos: ' . $e->getMessage()
    ]);
}
